﻿##############################################################################
# Portrait images
init:
    # Syntax: (directory, body expression, eyes, mouth, speaker)
    # Eyes/mouth: (x, y, sub-expression, idle)
    # If eyes/mouth sub-expression excluded, uses main expression
    # If [body expression]_eyes/mouth file does not exist, uses "neutral"
    # If eyes/mouth overall is None, renders nothing.
    # idle for the mouth shows a special frame during idle
    # for the eyes it replaces blinking
    # Speaker is the string ID tied to Character()s
    # If speaker excluded, uses directory name
    
    image tamati neutral     = Portrait("tamati", "neutral", (298, 209), (339, 277))
    image tamati neutral closed = Portrait("tamati", "neutral", (298, 209, None, "closed"), (339, 277))
    image tamati scowl       = Portrait("tamati", "neutral", (298, 209, "scowl"), (339, 277))
    image tamati scowl aside = Portrait("tamati", "neutral", (298, 209, "scowlaside"), (339, 277)) 
    image tamati grimace     = Portrait("tamati", "neutral", (298, 209, "scowl"), (339, 277, None, "grimace"))
        
##############################################################################
# Character definitions

define nv      = CharTemplate(quote=False, mode=nvl)
define will    = CharTemplate("Will",       file="vb_mid2.ogg",     speaker=("will"))
define tamati  = CharTemplate("Tamati",     file="vb_low2.ogg",     speaker=("tamati"))

# Misc images
image bg null = "#eee"
image bg demobg = "images/demobg.jpg"

image asset base = "images/char/tamati/neutral_base.png"
image asset eyes = "images/char/tamati/neutral_eyes.png"
image asset mouth = "images/char/tamati/neutral_mouth.png"
image asset grimace = "images/char/tamati/grimace_mouth_i.png"
image asset closed = "images/char/tamati/closed_eyes.png"

##############################################################################

label start:

    scene bg demobg
    
    window show
    will "Hey,{w=0.4} Tamati."
    show tamati neutral at char_fade, center, close
    tamati "Huh?{w=0.4} What?"
    will "Can you help me with this portrait engine?"
    
    label topmenu:
    tamati "Alright,{w=0.4} what is it that you need?"
    menu:
        extend ""
        "Demonstrate poses":
            call demo_poses
        "Syntax and image information":
            call demo_syntax
        "Making characters speak with {=h}speaker{/h}":
            call demo_speaker
        "Just give me a summary":
            call demo_summary
        "Credits":
            call demo_credits
    jump topmenu
    return
    
    
label demo_poses:
    
    will "Can you to demonstrate some expressions for me?"
    show tamati scowl aside
    tamati "...{w=0.4} really?"
    show tamati scowl
    tamati "Why do I have to be the guinea-pig?"
    will "You're not the guinea-pig,{w=0.4} you're my rubber duck."
    tamati "Ah.{w=0.4} You're using me to determine whether this portrait engine works?{w} You want me to help you make sure all the different kinds of expressions function?"
    will "...{w=0.4} ...{w} in too many words,{w=0.4} yes."
    show tamati grimace
    tamati "Ugh..."
    show tamati neutral closed 
    extend "fine,{w=0.4}{nw}"
    show tamati scowl aside
    extend " I guess I can help you."  
    show tamati neutral
    return

    
label demo_syntax:
    
    will "Can you go over the syntax for defining portraits?{w} And whatever else?"
    show tamati scowl aside
    tamati "Oh boy."
    show tamati neutral
    tamati "Alright,{w=0.4} strap in man."
    window hide
    
    nvl show
    nv "First of all,{w=0.4} we should go over how the portrait graphics are stored and structured."
    nv "By default, they are kept in {=h}/images/char/{/h}, in directories for each character.{w} So Tamati's graphics are under {=h}/images/char/tamati/{/h}.{w} This can be changed yourself early on in the script."
    nv "Each expression is generally comprised of three graphics:"
    nv "- expression_{=h}base{/h}.png{w=0.4}\n- expression_{=h}eyes{/h}.png{w=0.4}\n- expression_{=h}mouth{/h}.png"
    nv "You set {=h}expression{/h} to whatever you wish, and the system will put them together."
    nvl clear
    nvl hide
    
    pause(0.4)
    show tamati neutral at char_fade, right, close
    show asset base at char_fade, left, far
    pause(0.6)
    
    window show
    tamati "The {=h}base{/h} graphic is very straight forward.{w=0.4} It's the base portrait which you'll be drawing the eyes/mouth over.{w} You don't {i}have{/i} to exclude the eyes or mouth, but that might not work out depending on how you create your assets."
    show asset eyes at char_fade, close
    tamati "As can be seen, the {=h}eyes{/h} graphic is a set of frames for the blinking animation.{w} The graphics can be any size, as long as they're arranged vertically and divided by three, equally."
    show asset mouth
    tamati "The same is true for the mouth."
    tamati "Both of these graphics use the {=h}neutral{/h} prefix,{w=0.4} so that they'll be used with {=h}neutral_base{/h}."
    show tamati scowl aside at char_fade, right, close
    tamati "You can make these graphics transparent,{w=0.4} I just found this easier for testing purposes."
    show tamati neutral
    tamati "You can also use different expressions with different bases,{w=0.4} but we'll go over that in a sec."
    window hide
    hide asset at char_fade
    pause(0.4)
    
    nvl show
    nv "The {=h}Portrait(){/h} function's arguments are:\n{=h}(directory, body expression, eyes, mouth, speaker){/h}"
    nv "For example, Tamati's here is: {=h}Portrait(\"tamati\", \"neutral\", (298, 209), (339, 277)){/h}"
    nv "As you can see, the code specifies the {=h}tamati{/h} directory,{w=0.4} and looks for any images starting with {=h}neutral_{/h}.{w} It then gives the co-ordinates for the eyes and mouth."
    nv "The eyes and mouth have their own arguments.{w}\nThey are {=h}(x, y, sub-expression, idle){/h}."
    nv "The first two should be clear enough.{w} The {=h}sub-expression{/h} lets you refer to a different graphic to the {=h}body expression{/h}.{w} We'll get to {=h}idle{/h} later."
    nvl clear
    nvl hide
    pause(0.4)
    
    show tamati neutral at char_fade, center, close
    
    window show
    tamati "For example..."
    show tamati scowl aside
    tamati "This expression clearly uses the same base graphic and mouth animation.{w} However, the eyes are different."
    tamati "For this, the syntax is {=h}Portrait(\"tamati\", \"neutral\", (298, 209, \"scowlaside\"), (339, 277)){/h}.{w} The syntax is mostly the same, but the eye arguments now have a {=h}sub-expression{/h} argument."
    tamati "This uses {=h}scowlaside_eyes.png{/h}.{w} The co-ordinates are the same simply because of the same base portrait, {=h}neutral{/h}."
       
    show tamati neutral at char_fade
    tamati "As a reminder,{w=0.4} the eyes and mouth arguments are {=h}(x, y, sub-expression, idle){/h}.{w} You're probably wondering about {=h}idle{/h}.{w} That argument is different depending on if it's for eyes or the mouth."
    
    show tamati neutral at char_fade, right, close
    show asset closed at char_fade, left, close
    
    tamati "For example,{w=0.4} for the eyes..."
    show tamati neutral closed
    tamati "It lets you override the blinking animation with a single static frame.{w} Naturally the graphic for this frame will need to be a single frame too."
    tamati "The syntax for this expression is {=h}Portrait(\"tamati\", \"neutral\", (298, 209, None, \"closed\"), (339, 277)){/h}."
    show tamati neutral
    tamati "The important part is {=h}(298, 209, None, \"closed\"){/h}.{w} You've got your usual arguments, with the custom eye expression set to None as it's not needed here."
    tamati "That fourth argument is {=h}closed{/h}, which will render {=h}closed_eyes.png{/h} as a static graphic for the eyes."
    
    show tamati grimace at char_fade, right, close
    hide asset

    tamati "Now...{w=0.4} as for the mouth idle argument..."
    tamati "Here it is instead used so you can specify an fourth idle mouth frame.{w} This is useful if the lip-flap shouldn't use the normal mouth-closed frame when idle."
    show asset grimace at char_fade, left, close
    tamati "Like the eye idle graphic,{w=0.4} it's a single frame."
    tamati "The syntax for this expression is {=h}Portrait(\"tamati\", \"neutral\", (298, 209, \"scowl\"), (339, 277, None, \"grimace\")){/h}."
    tamati "The thing to pay attention to is the mouth arguments {=h}(339, 277, None, \"grimace\"){/h}.{w} The first two arguments are the co-ordinates as usual, and the third is the unique expression.{w} Since it's None, it'll default to {=h}neutral{/h}."
    show tamati neutral
    tamati "But then there's {=h}grimace{/h}.{w=0.4} This fourth argument will make it look for expression_{=h}mouth_i{/h}.png.{w} As with all the graphics, you can change the naming syntax in the main code if you need to."
    tamati "So here,{w=0.4} it's {=h}grimace_mouth_i.png{/h}."
    hide asset
    pause(0.4)
    show tamati neutral at char_fade, center, close
    
    menu:
        "Gimme a summary":
            call demo_summary
        "Return to top menu":
            pass
    return
       
       
label demo_summary:

    window hide
    nvl show
    nv "Portrait Syntax\n{=h}Portrait(directory, body expression, eyes, mouth, speaker){/h}"
    nv "Eyes/mouth Syntax:\n{=h}(x, y, sub-expression, idle){/h}"
    nv "If eyes/mouth {=h}sub-expression{/h} excluded, uses {=h}body expression{/h}.\nIf {=h}body expression{/h}_eyes/mouth.png does not exist, uses {=h}neutral{/h}.\nIf eyes/mouth overall is {=h}None{/h}, renders nothing."
    nv "The {=h}idle{/h} argument has different effects for eyes and mouth.\n{=h}For eyes:{/h} overrides blink animation.\n{=h}For mouth:{/h} overrides closed mouth frame when not speaking."
    nv "You'll need to set {=h}sub-expression{/h} to a value or None to use {=h}idle{/h}."
    nv "The {=h}speaker{/h} is the string ID tied to Character()s.\nIf the speaker in Portrait() is excluded, it uses the {=h}directory{/h} name."
    nvl clear
    nvl hide
    
    show tamati neutral at char_fade, center, close
    
    window show
    return
    
       
label demo_speaker:

    show tamati scowl aside
    tamati "So,{w=0.4} obviously,{w=0.4} the engine needs a way to know who's talking to be able to animate lip-flap in the first place."
    show tamati neutral
    tamati "This is done through some extra code underneath the Portrait script.{w} It's largely based on the ancient Renpy Cookbook code,{w=0.4} but it seems to still work."
    tamati "You specify a {=h}speaker{/h} for {=h}Character()s{/h},{w=0.4} and the portraits will now animate based on whatever Character is currently speaking."
    tamati "This demo uses a shortcut to creating Characters called. {=h}CharTemplate(){/h},{w=0.4} largely to reduce cruft."
    tamati "You don't need this yourself, but you {i}do{/i} need a way to set the global variable {=h}speaking{/h} somehow."
    show tamati scowl aside
    tamati "Let's go over the CharTemplate()."
    window hide
    
    nvl show
    nv "Character Template Syntax\n{=h}CharTemplate(name, quote, mode, file, speaker){/h}"
    nv "name: the name displayed for dialogue."
    nv "quote: whether to wrap the dialogue in quote marks.{w} The style of quote marks can be edited by looking at the code for {=h}CharTemplate(){/h} and editing {=h}what_prefix and what_suffix{/h}."
    nv "mode: whether the Character is {=h}ADV (bottom of the screen) or NVL (full-screen){/h}."
    nv "file: the filename of the text-blip sound effect."
    nv "speaker:\n{=h}Speaker{/h} is the important element that ties the dialogue to the animation and sound effect of the portrait.{w} It must be formatted like {=h}speaker=(\"name\"){/h}."
    nvl clear
    nvl hide
    
    window show
    show tamati neutral
    tamati "If you want to define the {=h}speaker{/h} variable in your own Character() code, its syntax is {=h}callback=text_effect(file, speaker){/h}.{w} Similar to CharTemplate(),{w=0.4} it specifies the text-blip file and speaker variable."
    tamati "The important part is {=h}both a Character/CharTemplate() and a Portrait(){/h} must be connected in their use of {=h}speaker{/h}."
    tamati "{=h}Portrait()s{/h} {i}do{/i} have a fallback though,{w=0.4} in that they'll use the {=h}directory name{/h} as the speaker variable if it's not mentioned. But {=h}Character/CharTemplate(){/h} still needs it."
    tamati "To summarise:{w} a Portrait's {=h}directory{/h} or {=h}speaker{/h},{w=0.4} if they match a Character's {=h}speaker{/h},{w=0.4} will make the graphics talk."
    pause(0.4)

    return
    
    
label demo_credits:

    tamati "..."
    tamati "Not much to be said really.{w} Credit to {=h}Taylor{/h}/@Tayruu and {=h}Bryan Tsang{/h}/@bvtsang is greatly appreciated. Without Tsang's original code assistance this engine probably wouldn't exist."
    tamati "The portrait artwork in this demo is drawn by {=h}Taylor{/h}. This background is by {=h}Shijimi{/h}, from {a=http://www7b.biglobe.ne.jp/~osumashi/free_bg.html}here{/a}.{w}\nPlease note my art is not free for use."
    show tamati scowl aside
    tamati "The text-blip effect?{w} Well that's just recorded from\n{=h}9 Hours 9 Persons 9 Doors{/h} ...{w=0.4} hahah."
    show tamati neutral
    return
    